import flixel.text.FlxText;
import flixel.text.FlxTextBorderStyle;
import flixel.text.FlxTextFormatMarkerPair;
import flixel.text.FlxTextFormat;

public var pixelNotesForBF = true;
public var pixelNotesForDad = true;
public var enablePixelUI = true;
public var enablePixelGameOver = true;

var cdiThree:FlxSprite = new FlxSprite().loadGraphic(Paths.image("game/hud/cdi/three"));
var cdiTwo:FlxSprite = new FlxSprite().loadGraphic(Paths.image("game/hud/cdi/two"));
var cdiOne:FlxSprite = new FlxSprite().loadGraphic(Paths.image("game/hud/cdi/one"));
var cdiGo:FlxSprite = new FlxSprite();
cdiGo.frames = Paths.getFrames("game/hud/cdi/cdigo");
cdiGo.animation.addByPrefix("go", "cdigo go", 12, false);


import flixel.FlxCamera;
var ratio:FlxSprite;
var camRatio:FlxCamera;
static var daPixelZoom = 6;


/**
* UI
*/

function postCreate(){
	 // camRatio = new FlxCamera();
	 // camRatio.bgColor.alpha = 0;
	 PlayState.instance.comboGroup.visible = false;
	 iconP1.antialiasing = false;
	 iconP2.antialiasing = false;
	 // FlxG.cameras.add(camRatio);
	 healthBarBG.loadGraphic(Paths.image('game/hud/cdi/healthBar'));
	 healthBarBG.screenCenter(FlxAxes.X);
	 healthBarBG.y = 650;
	 healthBarBG.scale.set(2.1,2.1);

	 for (i in [accuracyTxt, missesTxt, scoreTxt]) { 
		i.setFormat(Paths.font("vinque.ttf"), 20);
		i.antialiasing = false; 
		i.textField.antiAliasType = 0;
		i.textField.sharpness = 400;
	  }
	  for (i in [cdiThree, cdiTwo, cdiOne, cdiGo]) {
		i.cameras = [camHUD2];
		i.scale.set(1.2, 1.2);
		i.screenCenter();
		i.visible = false;
		add(i);
	  }
	  add(cdiGo);

}
public var style:String = "cdi";

function onNoteCreation(event) {
	if (event.note.strumLine == playerStrums && !pixelNotesForBF) return;
	if (event.note.strumLine == cpuStrums && !pixelNotesForDad) return;

	event.cancel();

	var note = event.note;
	if (event.note.isSustainNote) {
		note.loadGraphic(Paths.image('game/notes/'+style+'/arrowEnds'), true, 7, 6);
		note.animation.add("hold", [event.strumID]);
		note.animation.add("holdend", [4 + event.strumID]);
	} else {
		note.loadGraphic(Paths.image('game/notes/'+style+'/arrows'), true, 17, 17);
		note.animation.add("scroll", [4 + event.strumID]);
	}
	note.scale.set(daPixelZoom, daPixelZoom);
	note.updateHitbox();
}

function onStrumCreation(event) {
	if (event.player == 1 && !pixelNotesForBF) return;
	if (event.player == 0 && !pixelNotesForDad) return;

	event.cancel();

	var strum = event.strum;
	strum.loadGraphic(Paths.image('game/notes/'+style+'/arrows'), true, 17, 17);
	strum.animation.add("static", [event.strumID]);
	strum.animation.add("pressed", [4 + event.strumID, 8 + event.strumID], 12, false);
	strum.animation.add("confirm", [12 + event.strumID, 16 + event.strumID], 24, false);

	strum.scale.set(daPixelZoom, daPixelZoom);
	strum.updateHitbox();
}

function onPostNoteCreation(event) {  
    var splashes = event.note;
	splashes.splash = "cdi-splash";
}

function onCountdown(event) {
	event.spritePath = null;
	if (event.soundPath != null) event.soundPath = 'cdi/' + style+event.soundPath;
	switch(event.swagCounter) {
		case 0: 
			cdiThree.visible = true;
		case 1: 
			cdiThree.visible = false;
			cdiTwo.visible = true;
		case 2: 
			cdiTwo.visible = false;
			cdiOne.visible = true;
			//FlxTween.tween(cdiOne.scale, {x: 1.1, y: 1.1}, (Conductor.stepCrochet / 1000) * 4);
		case 3: 	
			cdiOne.visible = false;
			cdiGo.animation.play("go");
			cdiGo.visible = true;
		case 4: 
			cdiGo.visible = false;

			
	};

}